<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:msdndomain="http://msdn.microsoft.com/aboutmsdn/rss/domains"
	version="1.0"
>

	<xsl:include href="languageStrings.xsl" />

	<xsl:template match='/*'>
		<xsl:if test="count(channel/item) &gt; 0">
			<table id="recentProjects" cellspacing="0" cellpadding="4" border="0" width="100%" style="margin-bottom: 4px;">
				<tbody>
					<tr id="recentProjectsTableHeader">
						<th id="recentProjectsHeader" class="groupHeading" align="left"><xsl:value-of select="$project" /></th>
						<!--
							<th id="recentProjectsModified" class="groupHeading" align="left"><nobr><xsl:value-of select="$lastChange" /></nobr></th>
						-->
					</tr>
				</tbody>
				<xsl:apply-templates select='channel' />
			</table>
		</xsl:if>
	</xsl:template>

	<xsl:template match='channel'>
		<xsl:apply-templates select="item" />
	</xsl:template>

	<xsl:template match='item'>
		<tr>
		   <xsl:if test="position() mod 2 = 0">
		      <xsl:attribute name="class">lightRow</xsl:attribute>
		   </xsl:if>
		   <xsl:if test="position() mod 2 = 1">
		       <xsl:attribute name="class">darkRow</xsl:attribute>
		    </xsl:if>
			<td>
				<a class="toolLink" href="javascript:clickMenu({index});" title="{file}"><xsl:apply-templates select='personality' /><xsl:value-of select="title" /></a>
			</td>
			<!--
				<td><xsl:value-of select="lastChange" /></td>
			-->
		</tr>
	</xsl:template>

	<xsl:template match='personality'>
		<xsl:choose>
			<xsl:when test=". = 1">
				<img src='bds:/Images/project_group.gif' width='16' height='16' style='border: 0px; margin-right: 5px;' />
			</xsl:when>
			<xsl:when test=". = 2">
				<img src='bds:/Images/project_d32.gif' width='16' height='16' style='border: 0px; margin-right: 5px;' />
			</xsl:when>
			<xsl:when test=". = 3">
				<img src='bds:/Images/project_dnet.gif' width='16' height='16' style='border: 0px; margin-right: 5px;' />
			</xsl:when>
			<xsl:when test=". = 4">
				<img src='bds:/Images/project_cs.gif' width='16' height='16' style='border: 0px; margin-right: 5px;' />
			</xsl:when>
			<xsl:when test=". = 5">
				<img src='bds:/Images/project_vb.gif' width='16' height='16' style='border: 0px; margin-right: 5px;' />
			</xsl:when>
			<xsl:when test=". = 6">
				<img src='bds:/Images/project_cpp.gif' width='16' height='16' style='border: 0px; margin-right: 5px;' />
			</xsl:when>
			<xsl:when test=". = 7">
				<img src='bds:/Images/project_design.gif' width='16' height='16' style='border: 0px; margin-right: 5px;' />
			</xsl:when>
			<xsl:otherwise>
				<img src='bds:/Images/project.gif' width='16' height='16' style='border: 0px; margin-right: 5px;' />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match='personalityName'>
		<xsl:choose>
			<xsl:when test=". = 1">
				<xsl:value-of select="$projectGroup" />
			</xsl:when>
			<xsl:when test=". = 2">
				<xsl:value-of select="$projectDWin32" />
			</xsl:when>
			<xsl:when test=". = 3">
				<xsl:value-of select="$projectDNet" />
			</xsl:when>
			<xsl:when test=". = 4">
				<xsl:value-of select="$projectCS" />
			</xsl:when>
			<xsl:when test=". = 5">
				<xsl:value-of select="$projectVB" />
			</xsl:when>
			<xsl:when test=". = 6">
				<xsl:value-of select="$projectCPP" />
			</xsl:when>
			<xsl:when test=". = 7">
				<xsl:value-of select="$projectDesigner" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$projectOther" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match='Projects'>
		<xsl:value-of select="." />
		<br />
	</xsl:template>

</xsl:stylesheet>
